package org.kodein.emoji.smileys_emotion.face_hand

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceHand() {
    add(intArrayOf(0x1f917), _SmilingFaceWithOpenHands)
    add(intArrayOf(0x1f92d), _FaceWithHandOverMouth)
    add(intArrayOf(0x1fae2), _FaceWithOpenEyesAndHandOverMouth)
    add(intArrayOf(0x1fae3), _FaceWithPeekingEye)
    add(intArrayOf(0x1f92b), _ShushingFace)
    add(intArrayOf(0x1f914), _ThinkingFace)
    add(intArrayOf(0x1fae1), _SalutingFace)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFaceHand() {
    yield(_SmilingFaceWithOpenHands)
    yield(_FaceWithHandOverMouth)
    yield(_FaceWithOpenEyesAndHandOverMouth)
    yield(_FaceWithPeekingEye)
    yield(_ShushingFace)
    yield(_ThinkingFace)
    yield(_SalutingFace)
}

internal val countFaceHand = 7

/**
 * All Emoji of the Smileys & Emotion: face-hand subgroup.
*/
public fun Emoji.Companion.sequenceFaceHand(): Sequence<Emoji> =
    sequence { yieldAllFaceHand() }

/**
 * All Emoji of the Smileys & Emotion: face-hand subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFaceHand(): List<Emoji> =
    ArrayList<Emoji>(countFaceHand).also { list -> sequenceFaceHand().forEach { list.add(it) } }

@Deprecated("Renamed listFaceHand.", replaceWith = ReplaceWith("listFaceHand()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFaceHand(): List<Emoji> =
    listFaceHand()
