package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithoutMouth: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😶",
        description = "face without mouth",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("face-without-mouth", "mouth-none"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: face without mouth.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithoutMouth: Emoji get() = _FaceWithoutMouth

/**
 * Alias to emoji [FaceWithoutMouth] (Smileys & Emotion: face-neutral-skeptical: face without mouth).
*/
public val Emoji.Companion.MouthNone: Emoji get() = _FaceWithoutMouth
