package org.kodein.emoji.smileys_emotion.face_tongue

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceTongue() {
    add(intArrayOf(0x1f60b), _FaceSavoringFood)
    add(intArrayOf(0x1f61b), _FaceWithTongue)
    add(intArrayOf(0x1f61c), _WinkingFaceWithTongue)
    add(intArrayOf(0x1f92a), _ZanyFace)
    add(intArrayOf(0x1f61d), _SquintingFaceWithTongue)
    add(intArrayOf(0x1f911), _MoneyMouthFace)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFaceTongue() {
    yield(_FaceSavoringFood)
    yield(_FaceWithTongue)
    yield(_WinkingFaceWithTongue)
    yield(_ZanyFace)
    yield(_SquintingFaceWithTongue)
    yield(_MoneyMouthFace)
}

internal val countFaceTongue = 6

/**
 * All Emoji of the Smileys & Emotion: face-tongue subgroup.
*/
public fun Emoji.Companion.sequenceFaceTongue(): Sequence<Emoji> =
    sequence { yieldAllFaceTongue() }

/**
 * All Emoji of the Smileys & Emotion: face-tongue subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFaceTongue(): List<Emoji> =
    ArrayList<Emoji>(countFaceTongue).also { list -> sequenceFaceTongue().forEach { list.add(it) } }

@Deprecated("Renamed listFaceTongue.", replaceWith = ReplaceWith("listFaceTongue()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFaceTongue(): List<Emoji> =
    listFaceTongue()
