package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _InputSymbols: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔣",
        description = "input symbols",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("input-symbols", "symbols"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: input symbols.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.InputSymbols: Emoji get() = _InputSymbols

/**
 * Alias to emoji [InputSymbols] (Symbols: alphanum: input symbols).
*/
public val Emoji.Companion.Symbols: Emoji get() = _InputSymbols
