package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TopArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔝",
        description = "TOP arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("top-arrow", "top", "arrow-top"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: arrow: TOP arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TopArrow: Emoji get() = _TopArrow

/**
 * Alias to emoji [TopArrow] (Symbols: arrow: TOP arrow).
*/
public val Emoji.Companion.Top: Emoji get() = _TopArrow

/**
 * Alias to emoji [TopArrow] (Symbols: arrow: TOP arrow).
*/
public val Emoji.Companion.ArrowTop: Emoji get() = _TopArrow
