package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Keycap7: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "7️⃣",
        description = "keycap: 7",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("keycap-7", "seven", "keycap-seven"),
        emoticons = listOf(),
        notoImageRatio = 0.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: keycap: keycap: 7.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Keycap7: Emoji get() = _Keycap7

/**
 * Alias to emoji [Keycap7] (Symbols: keycap: keycap: 7).
*/
public val Emoji.Companion.Seven: Emoji get() = _Keycap7

/**
 * Alias to emoji [Keycap7] (Symbols: keycap: keycap: 7).
*/
public val Emoji.Companion.KeycapSeven: Emoji get() = _Keycap7
