package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CheckBoxWithCheck: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "☑️",
        description = "check box with check",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("check-box-with-check", "vote"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: other-symbol: check box with check.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CheckBoxWithCheck: Emoji get() = _CheckBoxWithCheck

/**
 * Alias to emoji [CheckBoxWithCheck] (Symbols: other-symbol: check box with check).
*/
public val Emoji.Companion.Vote: Emoji get() = _CheckBoxWithCheck
