package org.kodein.emoji.symbols.zodiac

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Taurus: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♉",
        description = "Taurus",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("taurus", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: zodiac: Taurus.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Taurus: Emoji get() = _Taurus
