package org.kodein.emoji.travel_places.transport_air

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AirplaneDeparture: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🛫",
        description = "airplane departure",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("airplane-departure", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Travel & Places: transport-air: airplane departure.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AirplaneDeparture: Emoji get() = _AirplaneDeparture
