package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagParaguay: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇾",
        description = "flag: Paraguay",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-paraguay", "paraguay-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.8181819f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Paraguay.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagParaguay: Emoji get() = _FlagParaguay

/**
 * Alias to emoji [FlagParaguay] (Flags: country-flag: flag: Paraguay).
*/
public val Emoji.Companion.ParaguayFlag: Emoji get() = _FlagParaguay
