package org.kodein.emoji.objects.computer

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllComputer() {
    add(intArrayOf(0x1f50b), _Battery)
    add(intArrayOf(0x1faab), _LowBattery)
    add(intArrayOf(0x1f50c), _ElectricPlug)
    add(intArrayOf(0x1f4bb), _Laptop)
    add(intArrayOf(0x1f5a5, 0xfe0f), _DesktopComputer)
    add(intArrayOf(0x1f5a5), _DesktopComputer)
    add(intArrayOf(0x1f5a8, 0xfe0f), _Printer)
    add(intArrayOf(0x1f5a8), _Printer)
    add(intArrayOf(0x2328, 0xfe0f), _Keyboard)
    add(intArrayOf(0x2328), _Keyboard)
    add(intArrayOf(0x1f5b1, 0xfe0f), _ComputerMouse)
    add(intArrayOf(0x1f5b1), _ComputerMouse)
    add(intArrayOf(0x1f5b2, 0xfe0f), _Trackball)
    add(intArrayOf(0x1f5b2), _Trackball)
    add(intArrayOf(0x1f4bd), _ComputerDisk)
    add(intArrayOf(0x1f4be), _FloppyDisk)
    add(intArrayOf(0x1f4bf), _OpticalDisk)
    add(intArrayOf(0x1f4c0), _Dvd)
    add(intArrayOf(0x1f9ee), _Abacus)
}

internal suspend fun SequenceScope<Emoji>.yieldAllComputer() {
    yield(_Battery)
    yield(_LowBattery)
    yield(_ElectricPlug)
    yield(_Laptop)
    yield(_DesktopComputer)
    yield(_Printer)
    yield(_Keyboard)
    yield(_ComputerMouse)
    yield(_Trackball)
    yield(_ComputerDisk)
    yield(_FloppyDisk)
    yield(_OpticalDisk)
    yield(_Dvd)
    yield(_Abacus)
}

internal val countComputer = 14

/**
 * All Emoji of the Objects: computer subgroup.
*/
public fun Emoji.Companion.sequenceComputer(): Sequence<Emoji> =
    sequence { yieldAllComputer() }

/**
 * All Emoji of the Objects: computer subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listComputer(): List<Emoji> =
    ArrayList<Emoji>(countComputer).also { list -> sequenceComputer().forEach { list.add(it) } }

@Deprecated("Renamed listComputer.", replaceWith = ReplaceWith("listComputer()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allComputer(): List<Emoji> =
    listComputer()
