package org.kodein.emoji.symbols.gender

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FemaleSign: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♀️",
        description = "female sign",
        unicodeVersion = UnicodeVersion(4, 0),
        aliases = listOf("female-sign", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: gender: female sign.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FemaleSign: Emoji get() = _FemaleSign
