package org.kodein.emoji.travel_places.place_geographic

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BeachWithUmbrella: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏖️",
        description = "beach with umbrella",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("beach-with-umbrella", "beach"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-geographic: beach with umbrella.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BeachWithUmbrella: Emoji get() = _BeachWithUmbrella

/**
 * Alias to emoji [BeachWithUmbrella] (Travel & Places: place-geographic: beach with umbrella).
*/
public val Emoji.Companion.Beach: Emoji get() = _BeachWithUmbrella
