package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MirrorBall: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪩",
        description = "mirror ball",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("mirror-ball", "disco-ball"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Activities: game: mirror ball.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MirrorBall: Emoji get() = _MirrorBall

/**
 * Alias to emoji [MirrorBall] (Activities: game: mirror ball).
*/
public val Emoji.Companion.DiscoBall: Emoji get() = _MirrorBall
