package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCentralAfricanRepublic: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇫",
        description = "flag: Central African Republic",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-central-african-republic", "central-african-republic-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Central African Republic.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCentralAfricanRepublic: Emoji get() = _FlagCentralAfricanRepublic

/**
 * Alias to emoji [FlagCentralAfricanRepublic] (Flags: country-flag: flag: Central African Republic).
*/
public val Emoji.Companion.CentralAfricanRepublicFlag: Emoji get() = _FlagCentralAfricanRepublic
