package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagLibya: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇱🇾",
        description = "flag: Libya",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-libya", "libya-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Libya.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagLibya: Emoji get() = _FlagLibya

/**
 * Alias to emoji [FlagLibya] (Flags: country-flag: flag: Libya).
*/
public val Emoji.Companion.LibyaFlag: Emoji get() = _FlagLibya
