package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNorway: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇳🇴",
        description = "flag: Norway",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-norway", "norway-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.375f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Norway.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNorway: Emoji get() = _FlagNorway

/**
 * Alias to emoji [FlagNorway] (Flags: country-flag: flag: Norway).
*/
public val Emoji.Companion.NorwayFlag: Emoji get() = _FlagNorway
