package org.kodein.emoji.flags.flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TriangularFlag: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚩",
        description = "triangular flag",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("triangular-flag", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: flag: triangular flag.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TriangularFlag: Emoji get() = _TriangularFlag
