package org.kodein.emoji.food_drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.food_drink.food_fruit.*
import org.kodein.emoji.food_drink.food_vegetable.*
import org.kodein.emoji.food_drink.food_prepared.*
import org.kodein.emoji.food_drink.food_asian.*
import org.kodein.emoji.food_drink.food_marine.*
import org.kodein.emoji.food_drink.food_sweet.*
import org.kodein.emoji.food_drink.drink.*
import org.kodein.emoji.food_drink.dishware.*


internal fun EmojiFinder.addAllFoodDrink() {
    addAllFoodFruit()
    addAllFoodVegetable()
    addAllFoodPrepared()
    addAllFoodAsian()
    addAllFoodMarine()
    addAllFoodSweet()
    addAllDrink()
    addAllDishware()
}

internal suspend fun SequenceScope<Emoji>.yieldAllFoodDrink() {
    yieldAllFoodFruit()
    yieldAllFoodVegetable()
    yieldAllFoodPrepared()
    yieldAllFoodAsian()
    yieldAllFoodMarine()
    yieldAllFoodSweet()
    yieldAllDrink()
    yieldAllDishware()
}

internal val countFoodDrink = 135

/**
 * All Emoji of the Food & Drink group.
*/
public fun Emoji.Companion.sequenceFoodDrink(): Sequence<Emoji> =
    sequence { yieldAllFoodDrink() }

/**
 * All Emoji of the Food & Drink group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFoodDrink(): List<Emoji> =
    ArrayList<Emoji>(countFoodDrink).also { list -> sequenceFoodDrink().forEach { list.add(it) } }

internal fun allFoodDrinkSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "food_fruit" to { Emoji.listFoodFruit() },
        "food_vegetable" to { Emoji.listFoodVegetable() },
        "food_prepared" to { Emoji.listFoodPrepared() },
        "food_asian" to { Emoji.listFoodAsian() },
        "food_marine" to { Emoji.listFoodMarine() },
        "food_sweet" to { Emoji.listFoodSweet() },
        "drink" to { Emoji.listDrink() },
        "dishware" to { Emoji.listDishware() },
    )
