package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CupWithStraw: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥤",
        description = "cup with straw",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("cup-with-straw", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: drink: cup with straw.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CupWithStraw: Emoji get() = _CupWithStraw
