package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PrayerBeads: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📿",
        description = "prayer beads",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("prayer-beads", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: clothing: prayer beads.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PrayerBeads: Emoji get() = _PrayerBeads
