package org.kodein.emoji.objects.light_video

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Videocassette: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📼",
        description = "videocassette",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("videocassette", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: light & video: videocassette.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Videocassette: Emoji get() = _Videocassette
