package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceInClouds: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😶‍🌫️",
        description = "face in clouds",
        unicodeVersion = UnicodeVersion(13, 1),
        aliases = listOf("face-in-clouds", "lost"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: face in clouds.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceInClouds: Emoji get() = _FaceInClouds

/**
 * Alias to emoji [FaceInClouds] (Smileys & Emotion: face-neutral-skeptical: face in clouds).
*/
public val Emoji.Companion.Lost: Emoji get() = _FaceInClouds
