package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DownwardsButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔽",
        description = "downwards button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("downwards-button", "downwards", "arrow-down", "triangle-down"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: downwards button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DownwardsButton: Emoji get() = _DownwardsButton

/**
 * Alias to emoji [DownwardsButton] (Symbols: av-symbol: downwards button).
*/
public val Emoji.Companion.Downwards: Emoji get() = _DownwardsButton

/**
 * Alias to emoji [DownwardsButton] (Symbols: av-symbol: downwards button).
*/
public val Emoji.Companion.ArrowDown: Emoji get() = _DownwardsButton

/**
 * Alias to emoji [DownwardsButton] (Symbols: av-symbol: downwards button).
*/
public val Emoji.Companion.TriangleDown: Emoji get() = _DownwardsButton
