package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FastForwardButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⏩",
        description = "fast-forward button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("fast-forward-button", "fast-forward"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: fast-forward button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FastForwardButton: Emoji get() = _FastForwardButton

/**
 * Alias to emoji [FastForwardButton] (Symbols: av-symbol: fast-forward button).
*/
public val Emoji.Companion.FastForward: Emoji get() = _FastForwardButton
