package org.kodein.emoji.travel_places.place_other

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HotSprings: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♨️",
        description = "hot springs",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("hot-springs", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-other: hot springs.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HotSprings: Emoji get() = _HotSprings
