package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SixOclock: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕕",
        description = "six o’clock",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("six-oclock", "six-o-clock"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: time: six o’clock.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SixOclock: Emoji get() = _SixOclock

/**
 * Alias to emoji [SixOclock] (Travel & Places: time: six o’clock).
*/
public val Emoji.Companion.SixOClock: Emoji get() = _SixOclock
