/*
 * Decompiled with CFR 0.152.
 */
package org.kodein.emoji;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.kodein.emoji.Emoji;
import org.kodein.emoji.SkinTone;
import org.kodein.emoji.SkinTone1Emoji;
import org.kodein.emoji.SkinTone2Emoji;
import org.kodein.emoji._allEmojiKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0016B0\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0019\b\u0002\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kodein/emoji/EmojiTemplateCatalog;", "", "emojiList", "", "Lorg/kodein/emoji/Emoji;", "builder", "Lkotlin/Function1;", "Lorg/kodein/emoji/EmojiTemplateCatalog$Builder;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "aliases", "", "", "emoticons", "aliasRegex", "Lkotlin/text/Regex;", "replaceShortcodes", "string", "replaceEmoticons", "replace", "Builder", "emoji-kt"})
@SourceDebugExtension(value={"SMAP\nStrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Strings.kt\norg/kodein/emoji/EmojiTemplateCatalog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1863#2:97\n1863#2,2:98\n1863#2,2:100\n1864#2:102\n216#3,2:103\n1#4:105\n*S KotlinDebug\n*F\n+ 1 Strings.kt\norg/kodein/emoji/EmojiTemplateCatalog\n*L\n17#1:97\n18#1:98,2\n21#1:100,2\n17#1:102\n61#1:103,2\n*E\n"})
public final class EmojiTemplateCatalog {
    @NotNull
    private final Map<String, Emoji> aliases;
    @NotNull
    private final Map<String, Emoji> emoticons;
    @NotNull
    private final Regex aliasRegex;

    public EmojiTemplateCatalog(@NotNull List<? extends Emoji> emojiList, @NotNull Function1<? super Builder, Unit> builder) {
        Intrinsics.checkNotNullParameter(emojiList, (String)"emojiList");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        HashMap aliasMap = emojiList.size() == _allEmojiKt.getEmojiCount() ? new HashMap(_allEmojiKt.getEmojiAliasCount()) : new HashMap();
        HashMap emoticonMap = emojiList.size() == _allEmojiKt.getEmojiCount() ? new HashMap(_allEmojiKt.getEmojiEmoticonCount()) : new HashMap();
        Iterable $this$forEach$iv = emojiList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Emoji emoji = (Emoji)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = emoji.getDetails().getAliases();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String alias = (String)element$iv2;
                boolean bl2 = false;
                ((Map)aliasMap).put(alias, emoji);
            }
            $this$forEach$iv2 = emoji.getDetails().getEmoticons();
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String emoticon = (String)element$iv2;
                boolean bl3 = false;
                ((Map)emoticonMap).put(emoticon, emoji);
            }
        }
        builder.invoke((Object)new Builder(aliasMap, emoticonMap));
        this.aliases = aliasMap;
        this.emoticons = emoticonMap;
        this.aliasRegex = new Regex(":(?<alias>[a-zA-Z0-9_-]+)(~(?<tone1>[a-zA-Z-]+)(,(?<tone2>[a-zA-Z-]+))?)?:");
    }

    public /* synthetic */ EmojiTemplateCatalog(List list, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = EmojiTemplateCatalog::_init_$lambda$0;
        }
        this(list, (Function1<? super Builder, Unit>)function1);
    }

    @NotNull
    public final String replaceShortcodes(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.aliasRegex.replace((CharSequence)string, arg_0 -> EmojiTemplateCatalog.replaceShortcodes$lambda$6(this, arg_0));
    }

    @NotNull
    public final String replaceEmoticons(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String result = null;
        result = string;
        Map<String, Emoji> $this$forEach$iv = this.emoticons;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Emoji>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Emoji> element$iv;
            Map.Entry<String, Emoji> entry = element$iv = iterator.next();
            boolean bl = false;
            String emoticon = entry.getKey();
            Emoji emoji = entry.getValue();
            result = StringsKt.replace$default((String)result, (String)emoticon, (String)emoji.toString(), (boolean)false, (int)4, null);
        }
        return result;
    }

    @NotNull
    public final String replace(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.replaceEmoticons(this.replaceShortcodes(string));
    }

    private static final Unit _init_$lambda$0(Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final CharSequence replaceShortcodes$lambda$6(EmojiTemplateCatalog this$0, MatchResult match) {
        CharSequence charSequence;
        SkinTone skinTone;
        Object object;
        SkinTone tone1;
        SkinTone skinTone2;
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"alias");
        if (object2 == null || (object2 = object2.getValue()) == null) {
            return match.getValue();
        }
        Object alias = object2;
        Emoji emoji = this$0.aliases.get(alias);
        if (emoji == null) {
            return match.getValue();
        }
        Emoji emoji2 = emoji;
        Object object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"tone1");
        if (object3 != null && (object3 = object3.getValue()) != null) {
            Object it = object3;
            boolean bl = false;
            skinTone2 = SkinTone.Companion.fromAlias((String)it);
        } else {
            skinTone2 = tone1 = null;
        }
        if ((object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"tone2")) != null && (object = object.getValue()) != null) {
            Object it = object;
            boolean bl = false;
            skinTone = SkinTone.Companion.fromAlias((String)it);
        } else {
            skinTone = null;
        }
        SkinTone tone2 = skinTone;
        if (tone1 == null && tone2 == null) {
            charSequence = emoji2.toString();
        } else if (tone1 != null && tone2 == null) {
            Object object4 = emoji2 instanceof SkinTone1Emoji ? (SkinTone1Emoji)emoji2 : null;
            if (object4 == null || (object4 = object4.withSkinTone(tone1)) == null || (object4 = object4.toString()) == null) {
                object4 = match.getValue();
            }
            charSequence = (CharSequence)object4;
        } else if (tone1 != null && tone2 != null) {
            Object object5 = emoji2 instanceof SkinTone2Emoji ? (SkinTone2Emoji)emoji2 : null;
            if (object5 == null || (object5 = object5.withSkinTone(tone1, tone2)) == null || (object5 = object5.toString()) == null) {
                object5 = match.getValue();
            }
            charSequence = (CharSequence)object5;
        } else {
            charSequence = match.getValue();
        }
        return charSequence;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B1\b\u0000\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0005R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kodein/emoji/EmojiTemplateCatalog$Builder;", "", "aliases", "", "", "Lorg/kodein/emoji/Emoji;", "emoticons", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "addAlias", "", "alias", "emoji", "addEmoticon", "emoticon", "emoji-kt"})
    public static final class Builder {
        @NotNull
        private final Map<String, Emoji> aliases;
        @NotNull
        private final Map<String, Emoji> emoticons;

        public Builder(@NotNull Map<String, Emoji> aliases, @NotNull Map<String, Emoji> emoticons) {
            Intrinsics.checkNotNullParameter(aliases, (String)"aliases");
            Intrinsics.checkNotNullParameter(emoticons, (String)"emoticons");
            this.aliases = aliases;
            this.emoticons = emoticons;
        }

        public final void addAlias(@NotNull String alias, @NotNull Emoji emoji) {
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
            this.aliases.put(alias, emoji);
        }

        public final void addEmoticon(@NotNull String emoticon, @NotNull Emoji emoji) {
            Intrinsics.checkNotNullParameter((Object)emoticon, (String)"emoticon");
            Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
            this.emoticons.put(emoticon, emoji);
        }
    }
}

