package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagALandIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇽",
        description = "flag: Åland Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-a-land-islands", "a-land-islands-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5294118f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Åland Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagALandIslands: Emoji get() = _FlagALandIslands

/**
 * Alias to emoji [FlagALandIslands] (Flags: country-flag: flag: Åland Islands).
*/
public val Emoji.Companion.ALandIslandsFlag: Emoji get() = _FlagALandIslands
