package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagPeru: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇪",
        description = "flag: Peru",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-peru", "peru-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Peru.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagPeru: Emoji get() = _FlagPeru

/**
 * Alias to emoji [FlagPeru] (Flags: country-flag: flag: Peru).
*/
public val Emoji.Companion.PeruFlag: Emoji get() = _FlagPeru
