package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SpiralNotepad: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🗒️",
        description = "spiral notepad",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("spiral-notepad", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: office: spiral notepad.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SpiralNotepad: Emoji get() = _SpiralNotepad
