package org.kodein.emoji.people_body.person_resting

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonInBed: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🛌",
        description = "person in bed",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("person-in-bed", "in-bed"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-resting: person in bed.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonInBed: SkinTone1Emoji get() = _PersonInBed

/**
 * Alias to emoji [PersonInBed] (People & Body: person-resting: person in bed).
*/
public val Emoji.Companion.InBed: SkinTone1Emoji get() = _PersonInBed
