package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MendingHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "❤️‍🩹",
        description = "mending heart",
        unicodeVersion = UnicodeVersion(13, 1),
        aliases = listOf("mending-heart", "bandaged-heart"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: mending heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MendingHeart: Emoji get() = _MendingHeart

/**
 * Alias to emoji [MendingHeart] (Smileys & Emotion: heart: mending heart).
*/
public val Emoji.Companion.BandagedHeart: Emoji get() = _MendingHeart
