package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllHeart() {
    add(intArrayOf(0x1f48c), _LoveLetter)
    add(intArrayOf(0x1f498), _HeartWithArrow)
    add(intArrayOf(0x1f49d), _HeartWithRibbon)
    add(intArrayOf(0x1f496), _SparklingHeart)
    add(intArrayOf(0x1f497), _GrowingHeart)
    add(intArrayOf(0x1f493), _BeatingHeart)
    add(intArrayOf(0x1f49e), _RevolvingHearts)
    add(intArrayOf(0x1f495), _TwoHearts)
    add(intArrayOf(0x1f49f), _HeartDecoration)
    add(intArrayOf(0x2763, 0xfe0f), _HeartExclamation)
    add(intArrayOf(0x2763), _HeartExclamation)
    add(intArrayOf(0x1f494), _BrokenHeart)
    add(intArrayOf(0x2764, 0xfe0f, 0x200d, 0x1f525), _HeartOnFire)
    add(intArrayOf(0x2764, 0x200d, 0x1f525), _HeartOnFire)
    add(intArrayOf(0x2764, 0xfe0f, 0x200d, 0x1fa79), _MendingHeart)
    add(intArrayOf(0x2764, 0x200d, 0x1fa79), _MendingHeart)
    add(intArrayOf(0x2764, 0xfe0f), _RedHeart)
    add(intArrayOf(0x2764), _RedHeart)
    add(intArrayOf(0x1fa77), _PinkHeart)
    add(intArrayOf(0x1f9e1), _OrangeHeart)
    add(intArrayOf(0x1f49b), _YellowHeart)
    add(intArrayOf(0x1f49a), _GreenHeart)
    add(intArrayOf(0x1f499), _BlueHeart)
    add(intArrayOf(0x1fa75), _LightBlueHeart)
    add(intArrayOf(0x1f49c), _PurpleHeart)
    add(intArrayOf(0x1f90e), _BrownHeart)
    add(intArrayOf(0x1f5a4), _BlackHeart)
    add(intArrayOf(0x1fa76), _GreyHeart)
    add(intArrayOf(0x1f90d), _WhiteHeart)
}

internal suspend fun SequenceScope<Emoji>.yieldAllHeart() {
    yield(_LoveLetter)
    yield(_HeartWithArrow)
    yield(_HeartWithRibbon)
    yield(_SparklingHeart)
    yield(_GrowingHeart)
    yield(_BeatingHeart)
    yield(_RevolvingHearts)
    yield(_TwoHearts)
    yield(_HeartDecoration)
    yield(_HeartExclamation)
    yield(_BrokenHeart)
    yield(_HeartOnFire)
    yield(_MendingHeart)
    yield(_RedHeart)
    yield(_PinkHeart)
    yield(_OrangeHeart)
    yield(_YellowHeart)
    yield(_GreenHeart)
    yield(_BlueHeart)
    yield(_LightBlueHeart)
    yield(_PurpleHeart)
    yield(_BrownHeart)
    yield(_BlackHeart)
    yield(_GreyHeart)
    yield(_WhiteHeart)
}

internal val countHeart = 25

/**
 * All Emoji of the Smileys & Emotion: heart subgroup.
*/
public fun Emoji.Companion.sequenceHeart(): Sequence<Emoji> =
    sequence { yieldAllHeart() }

/**
 * All Emoji of the Smileys & Emotion: heart subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listHeart(): List<Emoji> =
    ArrayList<Emoji>(countHeart).also { list -> sequenceHeart().forEach { list.add(it) } }

@Deprecated("Renamed listHeart.", replaceWith = ReplaceWith("listHeart()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allHeart(): List<Emoji> =
    listHeart()
