package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MobilePhoneOff: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📴",
        description = "mobile phone off",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("mobile-phone-off", "phone-off"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: mobile phone off.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MobilePhoneOff: Emoji get() = _MobilePhoneOff

/**
 * Alias to emoji [MobilePhoneOff] (Symbols: av-symbol: mobile phone off).
*/
public val Emoji.Companion.PhoneOff: Emoji get() = _MobilePhoneOff
