package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PauseButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⏸️",
        description = "pause button",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("pause-button", "pause", "double-vertical-bar"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: pause button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PauseButton: Emoji get() = _PauseButton

/**
 * Alias to emoji [PauseButton] (Symbols: av-symbol: pause button).
*/
public val Emoji.Companion.Pause: Emoji get() = _PauseButton

/**
 * Alias to emoji [PauseButton] (Symbols: av-symbol: pause button).
*/
public val Emoji.Companion.DoubleVerticalBar: Emoji get() = _PauseButton
