package org.kodein.emoji.symbols.zodiac

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Leo: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♌",
        description = "Leo",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("leo", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: zodiac: Leo.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Leo: Emoji get() = _Leo
