package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SevenOclock: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕖",
        description = "seven o’clock",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("seven-oclock", "seven-o-clock"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: time: seven o’clock.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SevenOclock: Emoji get() = _SevenOclock

/**
 * Alias to emoji [SevenOclock] (Travel & Places: time: seven o’clock).
*/
public val Emoji.Companion.SevenOClock: Emoji get() = _SevenOclock
