package org.kodein.emoji.activities.award_medal

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ThirdPlaceMedal: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥉",
        description = "3rd place medal",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("3rd-place-medal", "bronze-medal"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Activities: award-medal: 3rd place medal.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ThirdPlaceMedal: Emoji get() = _ThirdPlaceMedal

/**
 * Alias to emoji [ThirdPlaceMedal] (Activities: award-medal: 3rd place medal).
*/
public val Emoji.Companion.BronzeMedal: Emoji get() = _ThirdPlaceMedal
