package org.kodein.emoji.animals_nature.animal_mammal

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CatFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🐱",
        description = "cat face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("cat-face", ),
        emoticons = listOf("=^.^="),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Animals & Nature: animal-mammal: cat face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CatFace: Emoji get() = _CatFace
