package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBrunei: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇳",
        description = "flag: Brunei",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-brunei", "brunei-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Brunei.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBrunei: Emoji get() = _FlagBrunei

/**
 * Alias to emoji [FlagBrunei] (Flags: country-flag: flag: Brunei).
*/
public val Emoji.Companion.BruneiFlag: Emoji get() = _FlagBrunei
