package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagEuropeanUnion: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇪🇺",
        description = "flag: European Union",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-european-union", "european-union-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: European Union.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagEuropeanUnion: Emoji get() = _FlagEuropeanUnion

/**
 * Alias to emoji [FlagEuropeanUnion] (Flags: country-flag: flag: European Union).
*/
public val Emoji.Companion.EuropeanUnionFlag: Emoji get() = _FlagEuropeanUnion
