package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMexico: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇽",
        description = "flag: Mexico",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-mexico", "mexico-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.75f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Mexico.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMexico: Emoji get() = _FlagMexico

/**
 * Alias to emoji [FlagMexico] (Flags: country-flag: flag: Mexico).
*/
public val Emoji.Companion.MexicoFlag: Emoji get() = _FlagMexico
