package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSark: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇶",
        description = "flag: Sark",
        unicodeVersion = UnicodeVersion(16, 0),
        aliases = listOf("flag-sark", "sark-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Sark.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSark: Emoji get() = _FlagSark

/**
 * Alias to emoji [FlagSark] (Flags: country-flag: flag: Sark).
*/
public val Emoji.Companion.SarkFlag: Emoji get() = _FlagSark
