package org.kodein.emoji.objects.light_video

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ClapperBoard: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎬",
        description = "clapper board",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("clapper-board", "clapper"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Objects: light & video: clapper board.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ClapperBoard: Emoji get() = _ClapperBoard

/**
 * Alias to emoji [ClapperBoard] (Objects: light & video: clapper board).
*/
public val Emoji.Companion.Clapper: Emoji get() = _ClapperBoard
