package org.kodein.emoji.people_body.hand_fingers_partial

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _HandWithIndexFingerAndThumbCrossed: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🫰",
        description = "hand with index finger and thumb crossed",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("hand-with-index-finger-and-thumb-crossed", "snap", "finger-heart"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-fingers-partial: hand with index finger and thumb crossed.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HandWithIndexFingerAndThumbCrossed: SkinTone1Emoji get() = _HandWithIndexFingerAndThumbCrossed

/**
 * Alias to emoji [HandWithIndexFingerAndThumbCrossed] (People & Body: hand-fingers-partial: hand with index finger and thumb crossed).
*/
public val Emoji.Companion.Snap: SkinTone1Emoji get() = _HandWithIndexFingerAndThumbCrossed

/**
 * Alias to emoji [HandWithIndexFingerAndThumbCrossed] (People & Body: hand-fingers-partial: hand with index finger and thumb crossed).
*/
public val Emoji.Companion.FingerHeart: SkinTone1Emoji get() = _HandWithIndexFingerAndThumbCrossed
