package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _BalletDancer: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧑‍🩰",
        description = "ballet dancer",
        unicodeVersion = UnicodeVersion(17, 0),
        aliases = listOf("ballet-dancer", "dancer-person"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-activity: ballet dancer.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BalletDancer: SkinTone1Emoji get() = _BalletDancer

/**
 * Alias to emoji [BalletDancer] (People & Body: person-activity: ballet dancer).
*/
public val Emoji.Companion.DancerPerson: SkinTone1Emoji get() = _BalletDancer
