package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiZWJImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PeopleWithBunnyEars: SkinTone2Emoji = SkinTone2EmojiZWJImpl(
    details = Emoji.Details(
        string = "👯",
        description = "people with bunny ears",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("people-with-bunny-ears", "bunny-ears"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
    zwjTemplate = "🧑‍🐰‍🧑",
    zwjUnicodeVersion = UnicodeVersion(17, 0),
    sk21c = 2,
    sk22c = 8,
)

/**
 * Emoji People & Body: person-activity: people with bunny ears.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PeopleWithBunnyEars: SkinTone2Emoji get() = _PeopleWithBunnyEars

/**
 * Alias to emoji [PeopleWithBunnyEars] (People & Body: person-activity: people with bunny ears).
*/
public val Emoji.Companion.BunnyEars: SkinTone2Emoji get() = _PeopleWithBunnyEars
