package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiZWJImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PeopleWrestling: SkinTone2Emoji = SkinTone2EmojiZWJImpl(
    details = Emoji.Details(
        string = "🤼",
        description = "people wrestling",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("people-wrestling", "wrestling"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
    zwjTemplate = "🧑‍🫯‍🧑",
    zwjUnicodeVersion = UnicodeVersion(17, 0),
    sk21c = 2,
    sk22c = 8,
)

/**
 * Emoji People & Body: person-sport: people wrestling.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PeopleWrestling: SkinTone2Emoji get() = _PeopleWrestling

/**
 * Alias to emoji [PeopleWrestling] (People & Body: person-sport: people wrestling).
*/
public val Emoji.Companion.Wrestling: SkinTone2Emoji get() = _PeopleWrestling
