package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiZWJImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _WomenWrestling: SkinTone2Emoji = SkinTone2EmojiZWJImpl(
    details = Emoji.Details(
        string = "🤼‍♀️",
        description = "women wrestling",
        unicodeVersion = UnicodeVersion(4, 0),
        aliases = listOf("women-wrestling", "wrestling-women"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
    zwjTemplate = "👩‍🫯‍👩",
    zwjUnicodeVersion = UnicodeVersion(17, 0),
    sk21c = 2,
    sk22c = 8,
)

/**
 * Emoji People & Body: person-sport: women wrestling.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WomenWrestling: SkinTone2Emoji get() = _WomenWrestling

/**
 * Alias to emoji [WomenWrestling] (People & Body: person-sport: women wrestling).
*/
public val Emoji.Companion.WrestlingWomen: SkinTone2Emoji get() = _WomenWrestling
